/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console.content;

import filenet.sim.api.VWSIMSession;
import filenet.sim.toolkit.console.IVWSIMConsoleActionListener;
import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleActionEvent;
import filenet.sim.toolkit.console.VWSIMConsolePerformer;
import filenet.sim.toolkit.console.content.VWSIMConsoleContentViewPane;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWDriverFrame;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JComponent;

public class VWSIMConsoleContentPane
extends JComponent
implements IVWSIMConsoleActionListener {
    public static final int LIST_VIEW = 0;
    public static final int LIST_SCENARIOS = 1;
    public static final int LIST_SIMULATIONS = 2;
    private VWSIMConsoleContentViewPane m_contentView = null;

    public VWSIMConsoleContentPane() {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.m_contentView = new VWSIMConsoleContentViewPane();
    }

    public static void main(String[] args) {
        VWDriverFrame frame = null;
        VWSIMConsoleContentPane panel = null;
        try {
            frame = new VWDriverFrame();
            Dimension dim = VWStringUtils.stringToDimension("450,330");
            if (dim == null) {
                dim = new Dimension(400, 300);
            }
            frame.setSize(dim.width, dim.height);
            panel = new VWSIMConsoleContentPane();
            frame.add((Component)panel, "Center");
            frame.show();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(VWSIMBaseNode node, int viewMode, Container parentContainer, Frame parentFrame, VWSIMConsolePerformer consolePerformer, VWSession theVWSession, VWSIMSession theSIMSession) {
        this.m_contentView.init(node, viewMode, parentContainer, parentFrame, consolePerformer, theVWSession, theSIMSession);
        this.add((Component)this.m_contentView, "Center");
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.m_contentView.setBounds(x, y, width, height);
    }

    public void setViewMode(int viewMode) {
    }

    public void refreshContent(VWSIMBaseNode folder) {
        this.m_contentView.refreshContent(folder);
    }

    public void refreshContent() {
        this.m_contentView.refreshContent();
    }

    public void addRow(Object obj) {
        this.m_contentView.addRow(obj);
    }

    public void setRefreshInterval(long interval) {
        this.m_contentView.setRefreshInterval(interval);
    }

    public long getRefreshInterval() {
        return this.m_contentView.getRefreshInterval();
    }

    public void consoleActionPerformed(VWSIMConsoleActionEvent evt) {
        this.m_contentView.consoleActionPerformed(evt);
    }

    public void addConsoleActionListener(IVWSIMConsoleActionListener cal) {
        this.m_contentView.addConsoleActionListener(cal);
    }

    public void releaseResources() {
        if (this.m_contentView != null) {
            this.m_contentView.releaseResources();
            this.m_contentView = null;
        }
        this.removeAll();
    }
}

